#include <iostream>
#include <vector>
#include <stack>
#include <algorithm>

struct koordinate {
    int x, h;
    int index;
};

bool sortiranje(koordinate a, koordinate b) {
    return a.x < b.x;
}

int check(int a, int b) {
    if (a == -1) return b;
    if (b == -1) return a;
    return a < b ? a : b;
}

int main() {
    int n;
    scanf("%d", &n);

    koordinate arr[100000];
    int ans[100000];
    int prethodni[100000], sledeci[100000];
    std::stack<int> st;

    for (int i = 0; i < n; i++) {
        scanf("%d", &arr[i].x);
        arr[i].index = i;
    }
    for (int i = 0; i < n; i++) scanf("%d", &arr[i].h);
    std::sort(arr, arr + n, sortiranje);
    for (int i=0;i<n;i++) prethodni[i]=sledeci[i]=-1;

    for (int i=n-1; i>=0; i--) {
        while (!st.empty() && arr[st.top()].h < arr[i].h) st.pop();
        if (!st.empty()) sledeci[i] = arr[st.top()].x - arr[i].x;
        st.push(i);
    }

    while(!st.empty()) st.pop();

    for (int i=0; i<n; i++) {
        while (!st.empty() && arr[st.top()].h<arr[i].h) st.pop();
        if (!st.empty()) prethodni[i]=arr[i].x-arr[st.top()].x;
        st.push(i);
    }
    
    for (int i=0;i<n;i++) {
        int rez=-1;
        int x=arr[i].x, h=arr[i].h;
        if (prethodni[i]>0) rez=check(rez, prethodni[i]);
        if (sledeci[i]>0) rez=check(rez, sledeci[i]);
        if (i>0 && arr[i-1].h>=h) {
            int max_x=arr[i-1].x+(arr[i-1].h-h);
            if (max_x<x) rez=check(rez, x-max_x);
        }
        if (i+1<n && arr[i+1].h>=h) {
            int min_x=arr[i+1].x-(arr[i+1].h-h);
            if (min_x>x) rez=check(rez, min_x-x);
        }

        ans[arr[i].index]=rez;
    }

    for (int i=0; i<n; i++) printf("%d\n", ans[i]);
}